/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.client.ui.element;

import com.lazrproductions.lazrslib.client.screen.ScreenUtilities;
import com.lazrproductions.lazrslib.client.screen.base.ScreenRect;
import com.lazrproductions.lazrslib.client.screen.base.ScreenTexture;
import com.lazrproductions.lazrslib.client.ui.element.AbstractElement;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class BulletListElement
extends AbstractElement {
    static final int LIST_ICON_SIZE = 16;
    static final int LIST_ITEM_PADDING = 7;
    final int width;
    final ScreenTexture bulletTexture;
    final List<Component> itemList;
    final int textColor;
    final boolean renderShadow;

    public BulletListElement(@Nonnull Minecraft instance, int width, @Nonnull ScreenTexture bulletTexture, @Nonnull List<Component> list, int textColor) {
        super(instance, BulletListElement.getTotalHeight(instance, width, list));
        this.width = width;
        this.bulletTexture = bulletTexture;
        this.itemList = list;
        this.textColor = textColor;
        this.renderShadow = true;
    }

    public BulletListElement(@Nonnull Minecraft instance, int width, @Nonnull ScreenTexture bulletTexture, @Nonnull List<Component> list, int textColor, boolean renderShadow) {
        super(instance, BulletListElement.getTotalHeight(instance, width, list));
        this.width = width;
        this.bulletTexture = bulletTexture;
        this.itemList = list;
        this.textColor = textColor;
        this.renderShadow = renderShadow;
    }

    @Override
    public void draw(@Nonnull Minecraft instance, @Nonnull GuiGraphics graphics, @Nonnull ScreenRect area, int mouseX, int mouseY, boolean mouseDown) {
        int totalHeight = 0;
        for (int i = 0; i < this.itemList.size(); ++i) {
            ScreenUtilities.drawTexture(graphics, area.toBlitCoordinates().move(-4, totalHeight).withWidth(16).withHeight(16), this.bulletTexture);
            int localHeight = instance.f_91062_.m_239133_((FormattedText)this.itemList.get(i), this.width - 12);
            ScreenUtilities.drawParagraph(instance, graphics, area.toBlitCoordinates().move(12, totalHeight).withWidth(area.toBlitCoordinates().getWidth() - 12).withHeight(localHeight), List.of(this.itemList.get(i)), this.textColor, this.renderShadow);
            totalHeight += localHeight + 7;
        }
    }

    static int getTotalHeight(@Nonnull Minecraft instance, int width, @Nonnull List<Component> list) {
        int totalHeight = 0;
        for (int i = 0; i < list.size(); ++i) {
            totalHeight += instance.f_91062_.m_239133_((FormattedText)list.get(i), width - 12) + 7;
        }
        return totalHeight;
    }
}

